/*
          
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                            J6Bollinger Bands.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 7
//----  
#property indicator_color1 Gray 
#property indicator_color2 Red
#property indicator_color3 Blue 
#property indicator_color4 Lime
#property indicator_color5 Blue
#property indicator_color6 Red
#property indicator_color7 Gray 
//----   
#property indicator_style1 4
#property indicator_style2 2
#property indicator_style3 4
#property indicator_style4 4
#property indicator_style5 4
#property indicator_style6 2
#property indicator_style7 4
//----    --------------------------------------------------------------------------------------------------+
extern int        Bands_Period = 100; //    J2Bollinger Bands
extern double Bands_Deviations = 2.0; //  
extern int           MA_method = 0;   //  
extern int           MA_Smooth = 20;  //    Moving Avereges
extern int        Bands_Smooth = 20;  //    Bollinger Bands
extern int        Smooth_Phase = 100; //  ,    -100 ... +100,     ; 
extern int          Bands_Shift = 0;  // c     
extern int  Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double UpperBuffer3 [];
double UpperBuffer2 [];
double UpperBuffer1 [];
double JMovingBuffer[];
double LowerBuffer1 [];
double LowerBuffer2 [];
double LowerBuffer3 [];
double Series_buffer[];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| J6Bollinger Bands initialization function                        | 
//+------------------------------------------------------------------+  
int init()
  {
//----    
   SetIndexStyle(0,DRAW_LINE); 
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE); 
   SetIndexStyle(4,DRAW_LINE);
   SetIndexStyle(5,DRAW_LINE); 
   SetIndexStyle(6,DRAW_LINE);
//---- 4       
   IndicatorBuffers(8);
   SetIndexBuffer(0,UpperBuffer3 );
   SetIndexBuffer(1,UpperBuffer2 );
   SetIndexBuffer(2,UpperBuffer1 );
   SetIndexBuffer(3,JMovingBuffer);
   SetIndexBuffer(4,LowerBuffer1 );
   SetIndexBuffer(5,LowerBuffer2 );
   SetIndexBuffer(6,LowerBuffer3 );
   SetIndexBuffer(7,Series_buffer);
//----   ,      
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(1,0);
   SetIndexEmptyValue(2,0);
   SetIndexEmptyValue(3,0);
   SetIndexEmptyValue(4,0);
   SetIndexEmptyValue(5,0);
   SetIndexEmptyValue(6,0);
//----   ,        
   int drawbegin=Bands_Period+30+Bands_Shift;
   SetIndexDrawBegin(0,drawbegin);
   SetIndexDrawBegin(1,drawbegin);
   SetIndexDrawBegin(2,drawbegin);
   SetIndexDrawBegin(3,drawbegin);
   SetIndexDrawBegin(4,drawbegin);
   SetIndexDrawBegin(5,drawbegin);
   SetIndexDrawBegin(6,drawbegin);
//----      
   SetIndexShift (0, Bands_Shift); 
   SetIndexShift (1, Bands_Shift); 
   SetIndexShift (2, Bands_Shift); 
   SetIndexShift (3, Bands_Shift); 
   SetIndexShift (4, Bands_Shift); 
   SetIndexShift (5, Bands_Shift); 
   SetIndexShift (6, Bands_Shift); 
//----        
   IndicatorShortName ("J4Bollinger Bands( Period="+Bands_Period+", Deviations="+Bands_Deviations+")"); 
   SetIndexLabel (0, "Upper3 Bands");
   SetIndexLabel (1, "Upper2 Bands");
   SetIndexLabel (2, "Upper1 Bands"); 
   SetIndexLabel (4, "Lower1 Bands"); 
   SetIndexLabel (5, "Lower2 Bands");
   SetIndexLabel (6, "Lower3 Bands");  
   string Moving;
   switch(MA_method)
           {
            case  0: Moving= "JSMA";break;
            case  1: Moving= "JEMA";break;
            case  2: Moving="JSSMA";break;
            case  3: Moving="JLWMA";break;
            default: Moving="JSMA";
           }
   SetIndexLabel (3, "JMoving Avereges "+Moving+" ("+Bands_Period+")");
//----     
   IndicatorDigits(Digits);
//----+      JJMASeries, nJMAnumber=7(    JJMASeries)
   if (Bands_Smooth<=1){if (JJMASeriesResize(1)!=1)return(-1);}
   else if (JJMASeriesResize(7)!=7)return(-1);
//----       
   JJMASeriesAlert (0,"Bands_Period",Bands_Period);
   JJMASeriesAlert (0,"MA_Smooth",   MA_Smooth);
   JJMASeriesAlert (1,"Smooth_Phase", Smooth_Phase);
   PriceSeriesAlert(Input_Price_Customs);
   if((MA_method<0)||(MA_method>3))
           Alert(" MA_method    0  3"
                                         +"    " 
                                                   +MA_method+ "   0");
//----     Bands_Period
   if(Bands_Period<1)Bands_Period=1; 
//----  
   return(0);
  }
//+------------------------------------------------------------------+  
//| J6Bollinger Bands iteration function                             | 
//+------------------------------------------------------------------+  
int start()
  {
//----       
if(Bars-1<=Bands_Period) return(0);
//----+       
double deviation1,deviation2,deviation3,Temp_Series,sum,midline,priceswing,Resalt;
//----+        
int reset,MaxBar,MaxBarBB,MaxBarBB1,bar,kk,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
//---- (    counted_bars  JJMASeries   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;MaxBar=Bars-1-Bands_Period;MaxBarBB=MaxBar-30-Bands_Period;MaxBarBB1=MaxBarBB-1;
//----+              
for(bar=limit;bar>=0;bar--)Series_buffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----       Bollinger Bands 
//----            
if (limit>MaxBar)
     {
      for(bar=limit;bar>=MaxBar;bar--)JMovingBuffer[bar]=0;
      limit=MaxBar;
     }
//----+   Moving Avereges
for(bar=limit;bar>=0;bar--)
     {
      //----+    Moving Avereges
      Temp_Series=iMAOnArray(Series_buffer,0,Bands_Period,0,MA_method, bar);
      //----+   Moving Avereges
      //----+    JJMASeries   0.  nJMA.Phase  nJMA.Length      (nJMA.din=0)
      Resalt=JJMASeries(0,0,MaxBar,limit,Smooth_Phase,MA_Smooth,Temp_Series,bar,reset);
      //----+       
      if(reset!=0)return(-1); 
      JMovingBuffer[bar]=Resalt; 
     }     
//---- ר Bollinger Bands 
//----        
if (limit>MaxBarBB)
     {
      for(bar=limit;bar>=MaxBarBB;bar--)
       {
        UpperBuffer3[bar]=0;
        UpperBuffer2[bar]=0;
        UpperBuffer1[bar]=0;
        LowerBuffer1[bar]=0;
        LowerBuffer2[bar]=0;
        LowerBuffer3[bar]=0;
       }
      limit=MaxBarBB;
     }
for(bar=limit;bar>=0;bar--)
   {         
     sum=0.0;
     midline=JMovingBuffer[bar];
     kk=bar+Bands_Period-1;
     while(kk>=bar)
      {
       priceswing=PriceSeries(Input_Price_Customs,kk)-midline;
       sum+=priceswing*priceswing;
       kk--;
      }
     deviation2=Bands_Deviations*MathSqrt(sum/Bands_Period);     
     deviation1=0.5*deviation2;
     deviation3=1.5*deviation2;
     if (Bands_Smooth>1)
        {
         //----+   JMA  Bollinger Bands      
         //----+ ----------------------------------------------------------------------------------------+            
         //----+      JJMASeries   1, 2, 3, 4, 5, 6. 
         //----+  nJJMA.Length      (nJJMA.din=0)
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=JJMASeries(1,0,MaxBarBB1,limit,Smooth_Phase,Bands_Smooth ,midline+deviation3,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer3[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=JJMASeries(2,0,MaxBarBB1,limit,Smooth_Phase,Bands_Smooth ,midline+deviation2,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer2[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+       
         Resalt=JJMASeries(3,0,MaxBarBB1,limit,Smooth_Phase,Bands_Smooth ,midline+deviation1,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer1[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=JJMASeries(4,0,MaxBarBB1,limit,Smooth_Phase,Bands_Smooth ,midline-deviation1,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer1[bar]=Resalt; 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=JJMASeries(5,0,MaxBarBB1,limit,Smooth_Phase,Bands_Smooth ,midline-deviation2,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer2[bar]=Resalt;  
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=JJMASeries(6,0,MaxBarBB1,limit,Smooth_Phase,Bands_Smooth ,midline-deviation3,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer3[bar]=Resalt;        
         //----+ ----------------------------------------------------------------------------------------+ 
        }
      else 
        {
         //----+  Bollinger Bands  JMA   
         UpperBuffer3[bar]=midline+deviation3;
         UpperBuffer2[bar]=midline+deviation2;
         UpperBuffer1[bar]=midline+deviation1;
         LowerBuffer1[bar]=midline-deviation1;
         LowerBuffer2[bar]=midline-deviation2;
         LowerBuffer3[bar]=midline-deviation3;
        }
      
   }
//----    
   return(0);
  }
//+----------------------------------------------------------------------------+

